/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

#define VOLUME_SAMPLES 50

struct Hit { vec3 p; vec3 n; int id; };

Hit intersectSphere(vec3 ori, vec3 dir, vec3 p, float r) {
    
    float a = dot(dir,dir), b = 2. * dot(dir,ori-p), c = dot(ori-p,ori-p)-(r*r);
    float d = (b*b)-4.*a*c;
    float l = (-b-sqrt(d))/(2.*a);
    
    vec3 pos = ori+dir*l;
    return Hit(pos,normalize(pos-p),(d >= 0. && l >= 0.) ? 0 : -1);
    
}
Hit intersect(vec3 ori, vec3 dir) {
	return intersectSphere(ori,dir,vec3(0.),1.);   
}

vec3 getLightVector(vec3 p) {
	return vec3(10.*cos(iGlobalTime),0.,3.)-p;
}

float hash (float n)
{
	return fract(sin(n)*43758.5453);
}
float noise (in vec3 x)
{
	vec3 p = floor(x);
	vec3 f = fract(x);
	f = f*f*(3.0-2.0*f);
	float n = p.x + p.y*57.0 + 113.0*p.z;
	float res = mix(mix(mix( hash(n+  0.0), hash(n+  1.0),f.x),
						mix( hash(n+ 57.0), hash(n+ 58.0),f.x),f.y),
					mix(mix( hash(n+113.0), hash(n+114.0),f.x),
						mix( hash(n+170.0), hash(n+171.0),f.x),f.y),f.z);
	return res;
}

vec3 calcScatter(vec3 ori, vec3 dir, Hit hit, vec2 fc) {
    vec3 sum = vec3(0.);
    float maxDst = min(5., distance(ori,hit.p));
    float weight = 1. / float(VOLUME_SAMPLES);
    float stepAm = maxDst * weight;
    vec3 p = ori;
    
    p += dir*(noise(vec3(2.*fc,iGlobalTime))*.075);
    for(int i = 0; i < VOLUME_SAMPLES; i++) {
        vec3 lv = getLightVector(p);
        vec3 ld = normalize(lv);
        Hit sh = intersect(p, ld);
        if(sh.id < 0) {
       		sum += vec3(1.);
        }
        p += dir * stepAm;
    }
    
    return sum * weight * .6;
}
    
void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = (fragCoord - iResolution.xy * .5) / iResolution.y;
    
    vec3 ori = vec3(0.,0.,-4.);
    vec3 dir = vec3(uv, 1.);
    
    vec3 col = vec3(0.);
    Hit  hit = intersect(ori, dir);
    if(hit.id == 0) {
    	vec3 lv = getLightVector(hit.p);
        vec3 ld = normalize(lv);
        vec3  r = normalize(reflect(dir, hit.n));
        
        float d = max(dot(ld,hit.n),0.);
        float s = pow(max(dot(ld,r),0.),60.);
        col = vec3(1.,0.,0.)*(.15+d)+s;
    }
    
    col += calcScatter(ori,dir,hit,fragCoord);
	fragColor = vec4(col,1.);
}

void main ( void )
{
   mainImage ( gl_FragColor, gl_FragCoord.xy );
}
